/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.xplat.common.sounds;

import at.petrak.paucal.api.PaucalAPI;
import at.petrak.paucal.xplat.common.ContributorsManifest;
import at.petrak.paucal.xplat.common.sounds.ImmediateAudioStream;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.JOrbisAudioStream;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HeadpatSoundInstance
implements SoundInstance {
    public static final String DUMMY_LOCATION = "dummy_headpat";
    protected final boolean isGithub;
    protected final String soundName;
    @Nullable
    protected JOrbisAudioStream stream;
    protected final Vec3 pos;
    protected final float pitch;
    protected Sound dummySound;
    protected final RandomSource random;

    public HeadpatSoundInstance(String name, boolean isGithub, Vec3 pos, float pitch, RandomSource random) {
        this.soundName = name;
        this.isGithub = isGithub;
        this.stream = this.isGithub ? ContributorsManifest.getSound(this.soundName) : null;
        this.pos = pos;
        this.pitch = pitch;
        this.random = random;
    }

    public ResourceLocation getLocation() {
        return PaucalAPI.modLoc(DUMMY_LOCATION);
    }

    @Nullable
    public WeighedSoundEvents resolve(SoundManager manager) {
        WeighedSoundEvents weightedSounds = manager.getSoundEvent(PaucalAPI.modLoc(DUMMY_LOCATION));
        this.dummySound = weightedSounds == null ? SoundManager.EMPTY_SOUND : weightedSounds.getSound(this.random);
        return weightedSounds;
    }

    public Sound getSound() {
        return this.dummySound;
    }

    public float getPitch() {
        return this.pitch;
    }

    public double getX() {
        return this.pos.x;
    }

    public double getY() {
        return this.pos.y;
    }

    public double getZ() {
        return this.pos.z;
    }

    public CompletableFuture<AudioStream> getStream(SoundBufferLibrary soundBuffers, Sound sound, boolean looping) {
        return this.getXplatAudioStreamCommon(soundBuffers, looping);
    }

    public CompletableFuture<AudioStream> getAudioStream(SoundBufferLibrary soundBuffers, ResourceLocation id, boolean looping) {
        return this.getXplatAudioStreamCommon(soundBuffers, looping);
    }

    protected CompletableFuture<AudioStream> getXplatAudioStreamCommon(SoundBufferLibrary soundBuffers, boolean looping) {
        if (this.isGithub) {
            if (this.stream == null) {
                return soundBuffers.getStream(PaucalAPI.modLoc(DUMMY_LOCATION), looping);
            }
            ImmediateAudioStream loadTheWholeStreamNow = new ImmediateAudioStream(this.stream);
            return CompletableFuture.completedFuture(loadTheWholeStreamNow);
        }
        ResourceLocation decompose = ResourceLocation.tryParse((String)this.soundName);
        ResourceLocation actualSoundPath = ResourceLocation.tryBuild((String)decompose.getNamespace(), (String)("sounds/" + decompose.getPath() + ".ogg"));
        return soundBuffers.getStream(actualSoundPath, looping);
    }

    public float getVolume() {
        return 1.0f;
    }

    public SoundInstance.Attenuation getAttenuation() {
        return SoundInstance.Attenuation.LINEAR;
    }

    public SoundSource getSource() {
        return SoundSource.PLAYERS;
    }

    public boolean isLooping() {
        return false;
    }

    public boolean isRelative() {
        return false;
    }

    public int getDelay() {
        return 0;
    }
}

