/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.xplat;

import at.petrak.paucal.xplat.PaucalGamerules;
import at.petrak.paucal.xplat.common.ContributorsManifest;
import at.petrak.paucal.xplat.common.ModRegistries;
import at.petrak.paucal.xplat.common.msg.MsgHeadpatSoundS2C;
import at.petrak.paucal.xplat.common.msg.MsgReloadContributorsS2C;
import dev.architectury.impl.NetworkAggregator;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaucalMod {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"paucal");

    public static void initialize() {
        ModRegistries.TRIGGER_TYPES.register();
        ModRegistries.SOUNDS.register();
        ModRegistries.STATS.register();
        PaucalGamerules.init();
        ContributorsManifest.loadContributors();
        PaucalMod.registerS2C(MsgHeadpatSoundS2C.TYPE, MsgHeadpatSoundS2C.CODEC, (pkt, buf) -> MsgHeadpatSoundS2C.handle(pkt));
        PaucalMod.registerS2C(MsgReloadContributorsS2C.TYPE, MsgReloadContributorsS2C.CODEC, (pkt, buf) -> MsgReloadContributorsS2C.handle(pkt));
    }

    private static <T extends CustomPacketPayload> void registerS2C(CustomPacketPayload.Type<T> packetType, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, NetworkManager.NetworkReceiver<T> receiver) {
        if (Platform.getEnvironment().equals((Object)Env.SERVER)) {
            NetworkAggregator.registerS2CType(packetType, codec, List.of());
        } else {
            NetworkAggregator.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), packetType, codec, Collections.emptyList(), receiver);
        }
    }
}

