package at.petrak.paucal.xplat.common.advancement;

import at.petrak.paucal.api.contrib.Contributor;
import at.petrak.paucal.xplat.common.ContributorsManifest;
import at.petrak.paucal.xplat.common.ModRegistries;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_175;
import net.minecraft.class_2048;
import net.minecraft.class_2096;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;

public class BeContributorTrigger extends class_4558<BeContributorTrigger.Instance> {
  public static final Codec<Instance> CODEC = RecordCodecBuilder.create(i -> i.group(
      class_2048.field_47250.optionalFieldOf("player").forGetter(Instance::comp_2029),
      class_2096.class_2100.field_45763.fieldOf("patron_level").forGetter(Instance::patronLevel),
      Codec.BOOL.optionalFieldOf("is_dev").forGetter(Instance::isDev)
  ).apply(i, Instance::new));

  public void trigger(class_3222 player) {
    super.method_22510(player, inst -> {
      var uuid = player.method_5667();
      var profile = ContributorsManifest.getContributor(uuid);
      if (profile == null) {
        return false;
      }

      return inst.patronLevel.method_9054(profile.getLevel())
          && (inst.isDev.isEmpty() || inst.isDev.get() == profile.isDev());
    });
  }

  @Override
  public Codec<Instance> method_54937() {
    return CODEC;
  }

  public record Instance(Optional<class_5258> player,
                         class_2096.class_2100 patronLevel,
                         Optional<Boolean> isDev)
      implements class_4558.class_8788 {
    public class_175<Instance> criterion() {
      return ModRegistries.BE_CONTRIBUTOR_TRIGGER.get().method_53699(this);
    }
  }
}
