package at.petrak.paucal.api.contrib;

import at.petrak.paucal.xplat.common.msg.MsgHeadpatSoundS2C;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class HeadpatSpec {
  protected final String location;
  protected final Type type;

  protected HeadpatSpec(String location) {
    this.location = location;

    if (location.contains(":") && class_2960.method_12829(location) != null) {
      this.type = Type.VANILLA;
    } else {
      this.type = Type.GITHUB;
    }
  }

  public static List<HeadpatSpec> loadFromJson(JsonElement element) {
    if (element == null) {
      return List.of();
    } else if (class_3518.method_15286(element)) {
      var loc = element.getAsString();
      var single = new HeadpatSpec(loc);
      return List.of(single);
    } else if (element instanceof JsonArray arr) {
      var out = new ArrayList<HeadpatSpec>();
      for (var elt : arr) {
        if (class_3518.method_15286(elt)) {
          out.add(new HeadpatSpec(elt.getAsString()));
        } else {
          throw new RuntimeException("Invalid entry in the headpat spec, expected list of strings");
        }
      }
      return out;
    }

    throw new RuntimeException("Invalid entry in the headpat spec, expected list of strings");
  }

  public MsgHeadpatSoundS2C makePacket(class_243 pos, float pitch, @Nullable class_1657 patter) {
    var optUuid = Optional.ofNullable(patter).map(class_1657::method_5667);
    return new MsgHeadpatSoundS2C(this.location, this.type == Type.GITHUB,
        pos, pitch,
        optUuid
    );
  }

  public enum Type {
    VANILLA,
    GITHUB,
  }
}
