/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.xplat.common.misc;

import at.petrak.paucal.api.contrib.Contributor;
import at.petrak.paucal.xplat.PaucalGamerules;
import at.petrak.paucal.xplat.common.ContributorsManifest;
import at.petrak.paucal.xplat.common.ModRegistries;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PatPat {
    public static InteractionResult onPat(Player player, Level world, InteractionHand hand, Entity entity, @Nullable EntityHitResult hitResult) {
        if (!world.getGameRules().getBoolean(PaucalGamerules.ALLOW_HEADPATS)) {
            return InteractionResult.PASS;
        }
        if (player.getItemInHand(hand).isEmpty() && player.isDiscrete() && hand == InteractionHand.MAIN_HAND && entity instanceof Player) {
            Vec3 pos;
            ServerLevel sworld;
            Player target = (Player)entity;
            Level level = player.level();
            if (level instanceof ServerLevel) {
                sworld = (ServerLevel)level;
                pos = target.getEyePosition();
                sworld.sendParticles((ParticleOptions)ParticleTypes.HEART, pos.x, pos.y + 0.5, pos.z, 1, 0.0, 0.0, 0.0, 0.1);
            } else {
                player.swing(hand);
            }
            PatPat.tryPlayPatSound(target.getUUID(), target.getEyePosition(), player, world);
            player.awardStat((ResourceLocation)ModRegistries.PLAYERS_PATTED.get());
            target.awardStat((ResourceLocation)ModRegistries.HEADPATS_GOTTEN.get());
            if (target.isOnFire()) {
                target.clearFire();
                pos = player.level();
                if (pos instanceof ServerLevel) {
                    sworld = (ServerLevel)pos;
                    pos = target.getEyePosition();
                    sworld.sendParticles((ParticleOptions)ParticleTypes.SMOKE, pos.x, pos.y + 0.5, pos.z, 10, 0.0, 0.0, 0.0, 0.1);
                }
                player.level().playSound(player, target.getX(), target.getY(), target.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean tryPlayPatSound(UUID pattee, Vec3 patteePos, @Nullable Player patter, Level world) {
        Contributor contributor = ContributorsManifest.getContributor(pattee);
        if (contributor != null) {
            return contributor.doHeadpatSound(patteePos, patter, world);
        }
        return false;
    }
}

