package at.petrak.paucal.xplat.common.sounds;

import javax.sound.sampled.AudioFormat;
import net.minecraft.class_4228;
import net.minecraft.class_4234;
import I;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ImmediateAudioStream implements class_4234 {
  protected final class_4228 backing;
  protected ByteBuffer lazyRead;

  public ImmediateAudioStream(class_4228 backing) {
    this.backing = backing;
    this.lazyRead = null;
  }

  @Override
  public AudioFormat method_19719() {
    return this.backing.method_19719();
  }

  @Override
  public ByteBuffer method_19720(int size) throws IOException {
    if (this.lazyRead == null) {
      this.lazyRead = this.backing.method_59757();
      this.backing.close();
    }

    var maxSize = Math.min(size, this.lazyRead.remaining());
    var out = this.lazyRead.slice(0, maxSize);
    this.lazyRead.position(this.lazyRead.position() + maxSize);
    return out;
  }

  @Override
  public void close() throws IOException {
    this.lazyRead.clear();
  }
}
