package at.petrak.paucal.xplat.common.command;

import Z;
import at.petrak.paucal.xplat.PaucalGamerules;
import at.petrak.paucal.xplat.common.misc.PatPat;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class CommandPatSound {
  public static void add(LiteralArgumentBuilder<class_2168> builder) {
    builder.then(class_2170.method_9247("patsound")
        .then(class_2170.method_9244("pattee", class_2191.method_9329()).executes(ctx -> {
          var pattees = class_2191.method_9330(ctx, "pattee");
          if (pattees.size() != 1) {
            ctx.getSource().method_9213(
                class_2561.method_43469("command.paucal.patSelf.bad_count", pattees.size()));
            return 0;
          }
          return execute(pattees.iterator().next().getId(), ctx);
        }))
        .executes(ctx -> execute(ctx.getSource().method_9207().method_5667(), ctx)));
  }

  private static int execute(UUID target, CommandContext<class_2168> ctx) {
    var enabled = ctx.getSource().method_9225().method_8450().method_8355(PaucalGamerules.ALLOW_HEADPATS);
    if (!enabled) {
      ctx.getSource().method_9213(class_2561.method_43471("command.paucal.patSelf.disabled"));
      return 0;
    }

    var player = ctx.getSource().method_44023();
    var pos = player != null ? player.method_33571() : ctx.getSource().method_9222();
    var ok = PatPat.tryPlayPatSound(target, pos, null, ctx.getSource().method_9225());
    if (ok) {
      ctx.getSource().method_9226(() -> class_2561.method_43469("command.paucal.patSelf.ok", target.toString()), false);
      return 1;
    } else {
      ctx.getSource().method_9213(class_2561.method_43469("command.paucal.patSelf.err", target.toString()));
      return 0;
    }
  }
}
