package at.petrak.paucal.xplat.common.command;

import at.petrak.paucal.api.contrib.Contributor;
import at.petrak.paucal.xplat.common.ContributorsManifest;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class CommandGetContributorInfo {
  public static void add(LiteralArgumentBuilder<class_2168> builder) {
    builder.then(class_2170.method_9247("getInfo")
        .then(class_2170.method_9244("target", class_2186.method_9305())
            .executes(ctx -> info(ctx, class_2186.method_9315(ctx, "target"), false))
            .then(class_2170.method_9247("getAll")
                .executes(ctx -> info(ctx, class_2186.method_9315(ctx, "target"), true)))
        ));
  }

  private static int info(CommandContext<class_2168> ctx, class_3222 target,
                          boolean allKVs) {
    var contrib = ContributorsManifest.getContributor(target.method_5667());
    if (contrib == null) {
      ctx.getSource()
          .method_9213(
              class_2561.method_43469("command.paucal.contributor.not_contributor", target.method_5476()));
      return 0;
    }
    var keySet = contrib.allKeys();

    var out = class_2561.method_43469("command.paucal.contributor",
        target.method_5476(), contrib.getLevel(), contrib.isDev(), keySet.size());
    if (allKVs) {
      var keys = keySet.stream().sorted().toList();
      for (var key : keys) {
        out.method_27693("\n- ");
        out.method_10852(class_2561.method_43470(key).method_27692(class_124.field_1065));
        out.method_10852(class_2561.method_43470(": "));
        out.method_10852(class_2561.method_43470(
            String.valueOf(contrib.otherVals().get(key))).method_27692(class_124.field_1076));
      }
    }
    ctx.getSource().method_9226(() -> out, true);
    return keySet.size();
  }
}
