package at.petrak.paucal.api.datagen;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_173;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_52.class_53;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_77;
import net.minecraft.class_7791;

public abstract class PaucalLootTableSubProvider implements class_7791 {
  protected final String modid;

  protected PaucalLootTableSubProvider(String modid) {
    this.modid = modid;
  }

  @Override
  public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> register) {
    var blockTables = new HashMap<class_2248, class_52.class_53>();
    var lootTables = new HashMap<class_5321<class_52>, class_52.class_53>();
    this.makeLootTables(blockTables, lootTables);

    for (var entry : blockTables.entrySet()) {
      register.accept(entry.getKey().method_26162(), entry.getValue().method_334(class_173.field_1172));
    }
    // isn't that slick
    lootTables.forEach(register);
  }

  protected abstract void makeLootTables(Map<class_2248, class_52.class_53> blockTables,
      Map<class_5321<class_52>, class_52.class_53> lootTables);

  protected class_55.class_56 dropThisPool(class_1935 item, int count) {
    return dropThisPool(item, class_44.method_32448(count));
  }

  protected class_55.class_56 dropThisPool(class_1935 item, class_5658 count) {
    return class_55.method_347()
        .method_352(count)
        .method_351(class_77.method_411(item));
  }

  @SafeVarargs
  protected final void dropSelf(Map<class_2248, class_52.class_53> lootTables, Supplier<? extends class_2248>... blocks) {
    for (var blockSupp : blocks) {
      var block = blockSupp.get();
      dropSelf(block, lootTables);
    }
  }

  protected void dropSelf(Map<class_2248, class_52.class_53> lootTables, class_2248... blocks) {
    for (var block : blocks) {
      dropSelf(block, lootTables);
    }
  }

  protected void dropSelf(class_2248 block, Map<class_2248, class_52.class_53> lootTables) {
    var table = class_52.method_324().method_336(dropThisPool(block, 1));
    lootTables.put(block, table);
  }

  protected void dropThis(class_2248 block, class_1935 drop, Map<class_2248, class_52.class_53> lootTables) {
    var table = class_52.method_324().method_336(dropThisPool(drop, 1));
    lootTables.put(block, table);
  }

  protected void dropThis(class_2248 block, class_1935 drop, class_5658 count,
      Map<class_2248, class_52.class_53> lootTables) {
    var table = class_52.method_324().method_336(dropThisPool(drop, count));
    lootTables.put(block, table);
  }
}
