package at.petrak.paucal.api.datagen;

import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7785;

/**
 * Post 1.19.4, the advancement provider is actually a thin wrapper around a list of these things.
 */
public abstract class PaucalAdvancementSubProvider implements class_7785 {
  protected final String modid;

  protected PaucalAdvancementSubProvider(String modid) {
    this.modid = modid;
  }

  protected class_185 simpleDisplay(class_1935 icon, String name, class_189 frameType) {
    return simpleDisplayWithBackground(icon, name, frameType, null);
  }

  protected class_185 simpleDisplayWithBackground(class_1935 icon, String name, class_189 frameType,
      @Nullable class_2960 background) {
    return display(new class_1799(icon), name, frameType, background, true, true, false);
  }

  protected class_185 display(class_1799 icon, String name, class_189 frameType, class_2960 background,
      boolean showToast, boolean announceChat, boolean hidden) {
    String expandedName = "advancement." + this.modid + ":" + name;
    return new class_185(icon,
        class_2561.method_43471(expandedName),
        class_2561.method_43471(expandedName + ".desc"),
        Optional.ofNullable(background), frameType, showToast, announceChat, hidden);
  }

  protected String prefix(String name) {
    return this.modid + ":" + name;
  }

  protected class_2960 modLoc(String name) {
    return class_2960.method_43902(modid, name);
  }
}
