package at.petrak.paucal.xplat.common.msg;

import at.petrak.paucal.api.PaucalCodecs;
import at.petrak.paucal.xplat.common.sounds.HeadpatSoundInstance;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1113;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4844;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

import static at.petrak.paucal.api.PaucalAPI.modLoc;

public record MsgHeadpatSoundS2C(String soundName, boolean isGithub, class_243 pos,
                                 float pitch, Optional<UUID> patter) implements class_8710 {
  public static final class_9154<MsgHeadpatSoundS2C> TYPE = new class_9154<>(modLoc("pat"));

  public static final class_9139<class_9129, MsgHeadpatSoundS2C> CODEC = class_9139.method_56906(
      class_9135.field_48554, MsgHeadpatSoundS2C::soundName,
      class_9135.field_48547, MsgHeadpatSoundS2C::isGithub,
      PaucalCodecs.VEC3, MsgHeadpatSoundS2C::pos,
      class_9135.field_48552, MsgHeadpatSoundS2C::pitch,
      class_9135.method_56382(class_4844.field_48453), MsgHeadpatSoundS2C::patter,
      MsgHeadpatSoundS2C::new
  );

  @Override
  public class_9154<? extends class_8710> method_56479() {
    return TYPE;
  }

  public static void handle(MsgHeadpatSoundS2C self) {
    class_310.method_1551().execute(new Runnable() {
      @Override
      public void run() {
        var sound = new HeadpatSoundInstance(self.soundName, self.isGithub, self.pos,
            self.pitch, class_1113.method_43221());

        var minecraft = class_310.method_1551();
        var player = minecraft.field_1724;
        if (player != null && !player.method_5667().equals(self.patter.orElse(null))) {
          minecraft.method_1483().method_4873(sound);
        }
      }
    });
  }
}
