/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.events;

import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.tooltip.ITooltipFunction;
import crafttweaker.api.tooltip.IngredientTooltips;
import crafttweaker.mc1120.formatting.IMCFormattedString;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import stanhebben.zenscript.util.Pair;

public class ClientEventHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemTooltip(ItemTooltipEvent ev) {
        List<String> tooltipList = ev.getToolTip();
        if (!ev.getItemStack().func_190926_b()) {
            IItemStack itemStack = CraftTweakerMC.getIItemStackForMatching(ev.getItemStack());
            Boolean clearTooltipFlag = IngredientTooltips.shouldClearToolTip((IItemStack)itemStack);
            if (clearTooltipFlag != null) {
                (clearTooltipFlag != false ? tooltipList.subList(1, tooltipList.size()) : tooltipList).clear();
            }
            ArrayList toRemove = new ArrayList();
            for (Integer line : IngredientTooltips.getTooltipLinesToRemove((IItemStack)itemStack)) {
                if (line <= 0 || line >= tooltipList.size()) continue;
                toRemove.add(tooltipList.get(line));
            }
            for (Pattern regex : IngredientTooltips.getTooltipsToRemove((IItemStack)itemStack)) {
                for (String s : tooltipList) {
                    if (!regex.matcher(s).find()) continue;
                    toRemove.add(s);
                }
            }
            tooltipList.removeAll(toRemove);
            for (Pair tooltip : IngredientTooltips.getTooltips((IItemStack)itemStack)) {
                tooltipList.add(((IMCFormattedString)tooltip.getKey()).getTooltipString());
            }
            for (Pair tooltip : IngredientTooltips.getAdvancedTooltips((IItemStack)itemStack)) {
                String s = ((ITooltipFunction)tooltip.getKey()).process(itemStack);
                if (s == null) continue;
                tooltipList.add(s);
            }
            boolean pressed = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            for (Pair tooltip : IngredientTooltips.getShiftTooltips((IItemStack)itemStack)) {
                if (pressed) {
                    tooltipList.add(((IMCFormattedString)tooltip.getKey()).getTooltipString());
                    continue;
                }
                if (tooltip.getValue() == null) continue;
                tooltipList.add(((IMCFormattedString)tooltip.getValue()).getTooltipString());
            }
            for (Pair tooltip : IngredientTooltips.getAdvancedShiftTooltips((IItemStack)itemStack)) {
                String s;
                if (pressed) {
                    s = ((ITooltipFunction)tooltip.getKey()).process(itemStack);
                    if (s == null) continue;
                    tooltipList.add(s);
                    continue;
                }
                if (tooltip.getValue() == null || (s = ((ITooltipFunction)tooltip.getValue()).process(itemStack)) == null) continue;
                tooltipList.add(s);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenEvent(GuiOpenEvent ev) {
    }
}

