/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.socket;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.socket.CrTWebSocketHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import java.net.URISyntaxException;

public class HttpServerHandler
extends ChannelInboundHandlerAdapter {
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpMessage) {
            CraftTweakerAPI.logInfo((String)"Full HTTP Message Received");
        } else if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            CraftTweakerAPI.logInfo((String)"Http Request Received");
            HttpHeaders headers = httpRequest.headers();
            CraftTweakerAPI.logInfo((String)("Connection : " + headers.get("Connection")));
            CraftTweakerAPI.logInfo((String)("Upgrade : " + headers.get("Upgrade")));
            if (headers.get("Connection").equalsIgnoreCase("Upgrade") || headers.get("Upgrade").equalsIgnoreCase("WebSocket")) {
                ctx.pipeline().replace((ChannelHandler)this, "websocketHandler", (ChannelHandler)new CrTWebSocketHandler());
                CraftTweakerAPI.logInfo((String)"CrTWebSocketHandler added to the pipeline");
                CraftTweakerAPI.logInfo((String)("Opened Channel : " + ctx.channel()));
                CraftTweakerAPI.logInfo((String)"Handshaking....");
                this.handleHandshake(ctx, httpRequest);
                CraftTweakerAPI.logInfo((String)"Handshake is done");
            }
        } else {
            CraftTweakerAPI.logWarning((String)"Incoming request is unknown");
        }
    }

    protected void handleHandshake(ChannelHandlerContext ctx, HttpRequest req) throws URISyntaxException {
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(req), "zslint", true);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(req);
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            handshaker.handshake(ctx.channel(), req);
        }
    }

    protected String getWebSocketURL(HttpRequest req) {
        CraftTweakerAPI.logInfo((String)("Req URI : " + req.uri()));
        String url = "ws://" + req.headers().get("Host") + req.uri();
        CraftTweakerAPI.logInfo((String)("Constructed URL : " + url));
        return url;
    }
}

