/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ctgui.api;

import com.blamejared.ctgui.api.GuiBase;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.opengl.GL11;

public class CheckButton
extends GuiCheckBox {
    protected GuiBase parent;
    protected List<GuiButton> incompatible = new ArrayList<GuiButton>();
    protected int backgroundSize = 100;

    public CheckButton(GuiBase parent, int id, int xPos, int yPos, String displayString, boolean isChecked) {
        super(id, xPos, yPos, displayString, isChecked);
        this.parent = parent;
    }

    public int getBackgroundSize() {
        return this.backgroundSize;
    }

    public void setBackgroundSize(int backgroundSize) {
        this.backgroundSize = backgroundSize;
    }

    public List<GuiButton> getIncompatible() {
        return this.incompatible;
    }

    public void setIncompatible(List<GuiButton> incompatible) {
        this.incompatible = incompatible;
    }

    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        if (this.visible) {
            this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.getButtonWidth() && mouseY < this.y + this.height;
            GlStateManager.enableAlpha();
            GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)0.0);
            GuiUtils.drawGradientRect((int)30, (int)(this.x - 2), (int)(this.y - 2), (int)(this.x + this.getBackgroundSize()), (int)(this.y + this.height + 2), (int)-1626341360, (int)-1626341360);
            GlStateManager.disableAlpha();
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)BUTTON_TEXTURES, (int)this.x, (int)this.y, (int)0, (int)46, (int)11, (int)this.height, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.zLevel);
            this.mouseDragged(mc, mouseX, mouseY);
            int color = 0xE0E0E0;
            if (this.packedFGColour != 0) {
                color = this.packedFGColour;
            } else if (!this.enabled) {
                color = 0xA0A0A0;
            }
            if (this.isChecked()) {
                this.drawGradientRect(this.x + 2, this.y + 2, this.x + 11 - 2, this.y + this.height - 2, Color.cyan.darker().getRGB(), Color.cyan.darker().getRGB());
            }
            this.drawString(mc.fontRenderer, this.displayString, this.x + 11 + 2, this.y + 2, color);
        }
    }

    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY) {
        if (this.enabled && this.visible && mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height) {
            this.setIsChecked(!this.isChecked());
            return true;
        }
        return false;
    }

    public void setIsChecked(boolean isChecked) {
        super.setIsChecked(isChecked);
        if (this.isChecked()) {
            for (GuiButton but : this.incompatible) {
                but.enabled = false;
                if (!(but instanceof CheckButton)) continue;
                ((CheckButton)but).setIsChecked(false);
            }
        } else {
            for (GuiButton but : this.incompatible) {
                but.enabled = true;
            }
        }
    }
}

