/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.proxies;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.mc1120.CraftTweaker;
import crafttweaker.mc1120.events.ClientEventHandler;
import crafttweaker.mc1120.game.MCGame;
import crafttweaker.mc1120.proxies.CommonProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.util.RecipeBookClient;
import net.minecraft.client.util.SearchTree;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;

public class ClientProxy
extends CommonProxy {
    @Override
    public void registerEvents() {
        super.registerEvents();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
    }

    @Override
    public void registerReloadListener() {
        super.registerReloadListener();
        IReloadableResourceManager manager = (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        manager.func_110542_a((IResourceManagerReloadListener)((ISelectiveResourceReloadListener)(resourceManager, resourcePredicate) -> {
            if (resourcePredicate.test(VanillaResourceType.LANGUAGES)) {
                for (IAction action : MCGame.TRANSLATION_ACTIONS) {
                    CraftTweakerAPI.apply((IAction)action);
                }
            }
        }));
    }

    @Override
    public void fixRecipeBook() {
        if (Loader.isModLoaded((String)"norecipebook")) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!CraftTweaker.alreadyChangedThePlayer) {
            CraftTweaker.alreadyChangedThePlayer = true;
            RecipeBookClient.rebuildTable();
            if (CraftTweakerAPI.ENABLE_SEARCH_TREE_RECALCULATION) {
                try {
                    minecraft.func_193986_ar();
                    ((SearchTree)minecraft.getSearchTreeManager().func_194010_a(SearchTreeManager.field_194011_a)).func_194040_a();
                    ((SearchTree)minecraft.getSearchTreeManager().func_194010_a(SearchTreeManager.field_194012_b)).func_194040_a();
                }
                catch (Exception ex) {
                    CraftTweakerAPI.logError((String)"Error repopulating the SearchTree Managers. If this problem occurs more often you can disable it with '#disable_search_tree' in any CrT script.", (Throwable)ex);
                }
            }
            CraftTweakerAPI.logInfo((String)"Fixed the RecipeBook");
        }
    }
}

