/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.entity.attribute;

import crafttweaker.api.entity.attribute.IEntityAttribute;
import crafttweaker.api.entity.attribute.IEntityAttributeInstance;
import crafttweaker.api.entity.attribute.IEntityAttributeModifier;
import crafttweaker.mc1120.entity.attribute.MCEntityAttribute;
import crafttweaker.mc1120.entity.attribute.MCEntityAttributeModifier;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;

public class MCEntityAttributeInstance
implements IEntityAttributeInstance {
    private final IAttributeInstance attributeInstance;

    public MCEntityAttributeInstance(IAttributeInstance attributeInstance) {
        this.attributeInstance = attributeInstance;
    }

    public IEntityAttribute getAttribute() {
        return new MCEntityAttribute(this.attributeInstance.func_111123_a());
    }

    public double getBaseValue() {
        return this.attributeInstance.func_111125_b();
    }

    public void setBaseValue(double baseValue) {
        this.attributeInstance.func_111128_a(baseValue);
    }

    public List<IEntityAttributeModifier> getModifiersByOperation(int operation) {
        return this.attributeInstance.func_111130_a(operation).stream().filter(Objects::nonNull).map(MCEntityAttributeModifier::new).collect(Collectors.toList());
    }

    public List<IEntityAttributeModifier> getModifiers() {
        return this.attributeInstance.func_111122_c().stream().map(MCEntityAttributeModifier::new).collect(Collectors.toList());
    }

    public boolean hasModifier(IEntityAttributeModifier modifier) {
        return this.attributeInstance.func_180374_a((AttributeModifier)modifier.getInternal());
    }

    public IEntityAttributeModifier getModifier(String uuid) {
        return Optional.ofNullable(this.attributeInstance.func_111127_a(UUID.fromString(uuid))).map(MCEntityAttributeModifier::new).orElse(null);
    }

    public void applyModifier(IEntityAttributeModifier modifier) {
        this.attributeInstance.func_111121_a((AttributeModifier)modifier.getInternal());
    }

    public void removeModifier(IEntityAttributeModifier modifier) {
        this.attributeInstance.func_188479_b((UUID)modifier.getInternal());
    }

    public void removeModifier(String uuid) {
        this.attributeInstance.func_188479_b(UUID.fromString(uuid));
    }

    public void removeAllModifiers() {
        this.attributeInstance.func_111122_c().forEach(arg_0 -> ((IAttributeInstance)this.attributeInstance).func_111124_b(arg_0));
    }

    public double getAttributeValue() {
        return this.attributeInstance.func_111126_e();
    }

    public Object getInternal() {
        return this.attributeInstance;
    }
}

