/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.block.BlockStateMatcherOr;
import crafttweaker.api.block.IBlockStateMatcher;
import crafttweaker.mc1120.block.MCBlockState;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;

public class BlockStateMatcher
implements IBlockStateMatcher {
    private final crafttweaker.api.block.IBlockState blockState;
    private final Map<String, List<String>> allowedProperties;

    public BlockStateMatcher(crafttweaker.api.block.IBlockState blockState, Map<String, List<String>> allowedProperties) {
        this.blockState = blockState;
        this.allowedProperties = ImmutableMap.copyOf(allowedProperties);
    }

    public BlockStateMatcher(crafttweaker.api.block.IBlockState blockState) {
        this(blockState, (Map<String, List<String>>)ImmutableMap.of());
    }

    public static IBlockStateMatcher create(crafttweaker.api.block.IBlockState ... blockStates) {
        if (blockStates == null) {
            throw new IllegalArgumentException("Cannot create matcher for null blockstate");
        }
        for (crafttweaker.api.block.IBlockState o : blockStates) {
            if (o != null) continue;
            throw new IllegalArgumentException("Cannot create matcher for null blockstate");
        }
        if (blockStates.length == 1) {
            return new BlockStateMatcher(blockStates[0]);
        }
        return new BlockStateMatcherOr((IBlockStateMatcher[])Arrays.copyOf(blockStates, blockStates.length));
    }

    public boolean matches(crafttweaker.api.block.IBlockState stateToMatch) {
        if (stateToMatch == null) {
            return false;
        }
        if (((IBlockState)this.blockState.getInternal()).func_177230_c().equals(((IBlockState)stateToMatch.getInternal()).func_177230_c())) {
            for (Map.Entry entry : ((IBlockState)stateToMatch.getInternal()).func_177228_b().entrySet()) {
                List<String> allowed = this.allowedProperties.get(((IProperty)entry.getKey()).func_177701_a());
                if (allowed == null || allowed.contains(((Comparable)entry.getValue()).toString()) || allowed.contains("*")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public IBlockStateMatcher or(IBlockStateMatcher matcher) {
        return new BlockStateMatcherOr((IBlockStateMatcher)this, matcher);
    }

    public Collection<crafttweaker.api.block.IBlockState> getMatchingBlockStates() {
        IBlockState state = (IBlockState)this.blockState.getInternal();
        return state.func_177230_c().func_176194_O().func_177619_a().stream().map(MCBlockState::new).filter(this::matches).collect(Collectors.toList());
    }

    public IBlockStateMatcher allowValuesForProperty(String name, String ... values) {
        CraftTweakerAPI.logWarning((String)"IBlockStateMatcher#allowValuesForProperty is deprecated. Please use IBlockStateMatcher#withMatchedValuesForProperty instead.");
        return this.withMatchedValuesForProperty(name, values);
    }

    public IBlockStateMatcher withMatchedValuesForProperty(String name, String ... values) {
        HashMap<String, List<String>> newProps = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.allowedProperties.entrySet()) {
            newProps.put(entry.getKey(), (List<String>)ImmutableList.copyOf((Collection)entry.getValue()));
        }
        ImmutableList newValues = ImmutableList.copyOf((Object[])values);
        if (newValues.contains("*") && newValues.size() > 1) {
            newProps.put(name, (List<String>)ImmutableList.of((Object)"*"));
        } else {
            newProps.put(name, (List<String>)newValues);
        }
        return new BlockStateMatcher(this.blockState, newProps);
    }

    public List<String> getMatchedValuesForProperty(String name) {
        if (this.allowedProperties.containsKey(name)) {
            return ImmutableList.copyOf((Collection)this.allowedProperties.get(name));
        }
        return ImmutableList.of((Object)"*");
    }

    public Map<String, List<String>> getMatchedProperties() {
        HashMap<String, ImmutableList> props = new HashMap<String, ImmutableList>();
        for (Map.Entry<String, List<String>> entry : this.allowedProperties.entrySet()) {
            props.put(entry.getKey(), ImmutableList.copyOf((Collection)entry.getValue()));
        }
        return ImmutableMap.copyOf(props);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Matcher (");
        IBlockState state = (IBlockState)this.blockState.getInternal();
        builder.append(state.func_177230_c().getRegistryName());
        if (!this.allowedProperties.isEmpty()) {
            builder.append(":");
            StringJoiner joiner = new StringJoiner(",");
            for (Map.Entry<String, List<String>> entry : this.allowedProperties.entrySet()) {
                joiner.add(entry.getKey() + "=" + entry.getValue());
            }
            builder.append(joiner);
        }
        return builder.append(")").toString();
    }

    public boolean isCompound() {
        return false;
    }

    public String toCommandString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.blockState.toCommandString());
        if (!this.allowedProperties.isEmpty()) {
            for (Map.Entry<String, List<String>> allowedProperty : this.allowedProperties.entrySet()) {
                builder.append(".withMatchedValuesForProperty(");
                builder.append(allowedProperty.getKey()).append(", ");
                builder.append(allowedProperty.getValue().toString());
                builder.append(")");
            }
        }
        return builder.toString();
    }
}

