/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.item;

import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IMutableItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.mc1120.data.NBTConverter;
import crafttweaker.mc1120.data.NBTUpdater;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class MCMutableItemStack
extends MCItemStack
implements IMutableItemStack {
    public MCMutableItemStack(ItemStack itemStack) {
        super(itemStack, NBTConverter.from((NBTBase)itemStack.getTagCompound(), false));
    }

    public MCMutableItemStack(ItemStack itemStack, boolean wildcardSize) {
        super(itemStack, NBTConverter.from((NBTBase)itemStack.getTagCompound(), false), wildcardSize);
    }

    public void shrink(int quality) {
        this.origin.shrink(quality);
    }

    public void grow(int quality) {
        this.origin.grow(quality);
    }

    public boolean attemptDamageItem(int amount, IPlayer player) {
        EntityPlayer mcplayer = CraftTweakerMC.getPlayer(player);
        return this.origin.attemptDamageItem(amount, mcplayer != null ? mcplayer.world.rand : new Random(), mcplayer instanceof EntityPlayerMP ? (EntityPlayerMP)mcplayer : null);
    }

    @Override
    public IItemStack withTag(IData tag, boolean matchTagExact) {
        this.matchTagExact = matchTagExact;
        this.tag = tag;
        this.origin.setTagCompound(CraftTweakerMC.getNBTCompound(tag));
        return this;
    }

    @Override
    public IItemStack updateTag(IData tagUpdate, boolean matchTagExact) {
        this.matchTagExact = matchTagExact;
        if (this.tag == null) {
            if (this.origin.getTagCompound() == null) {
                return this.withTag(tagUpdate, matchTagExact);
            }
            this.tag = NBTConverter.from((NBTBase)this.origin.getTagCompound(), false);
        }
        NBTUpdater.updateMap(this.origin.getTagCompound(), tagUpdate);
        this.tag = this.tag.update(tagUpdate);
        return this;
    }

    @Override
    public IItemStack withEmptyTag() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.tag = NBTConverter.from((NBTBase)nbt, false);
        this.origin.setTagCompound(nbt);
        return this;
    }

    @Override
    public IItemStack removeTag(String tag) {
        if (tag == null) {
            this.origin.setTagCompound(null);
        } else {
            this.origin.getTagCompound().removeTag(tag);
        }
        this.tag = NBTConverter.from((NBTBase)this.origin.getTagCompound(), false);
        return this;
    }

    @Override
    public IItemStack withAmount(int amount) {
        this.origin.setCount(amount);
        return this;
    }

    @Override
    public IItemStack withDamage(int damage) {
        this.origin.setItemDamage(damage);
        return this;
    }

    @Override
    public IItemStack withDisplayName(String name) {
        NBTTagCompound tagComp = !this.origin.hasTagCompound() || this.origin.getTagCompound() == null ? new NBTTagCompound() : this.origin.getTagCompound();
        NBTTagCompound display = !tagComp.hasKey("display") || !(tagComp.getTag("display") instanceof NBTTagCompound) ? new NBTTagCompound() : (NBTTagCompound)tagComp.getTag("display");
        display.setString("Name", name);
        tagComp.setTag("display", (NBTBase)display);
        this.origin.setTagCompound(tagComp);
        return this;
    }

    @Override
    public IItemStack withLore(String[] lore) {
        NBTTagCompound tagComp = !this.origin.hasTagCompound() || this.origin.getTagCompound() == null ? new NBTTagCompound() : this.origin.getTagCompound();
        NBTTagCompound display = !tagComp.hasKey("display") || !(tagComp.getTag("display") instanceof NBTTagCompound) ? new NBTTagCompound() : (NBTTagCompound)tagComp.getTag("display");
        NBTTagList loreList = !display.hasKey("Lore") || !(display.getTag("Lore") instanceof NBTTagList) ? new NBTTagList() : (NBTTagList)display.getTag("Lore");
        for (String s : lore) {
            loreList.appendTag((NBTBase)new NBTTagString(s));
        }
        display.setTag("Lore", (NBTBase)loreList);
        tagComp.setTag("display", (NBTBase)display);
        this.origin.setTagCompound(tagComp);
        return this;
    }

    public IItemStack copy() {
        return new MCItemStack(this.origin.copy());
    }

    @Override
    public IMutableItemStack mutable() {
        return this.origin.isEmpty() ? null : this;
    }

    @Override
    public void damageItem(int amount, IEntity entity) {
        if (entity.getInternal() instanceof EntityLivingBase) {
            this.origin.damageItem(amount, (EntityLivingBase)entity.getInternal());
        }
    }

    @Override
    public Object getInternal() {
        return this.origin;
    }
}

