/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.item;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemCondition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IItemTransformer;
import crafttweaker.api.item.IItemTransformerNew;
import crafttweaker.api.item.IngredientOr;
import crafttweaker.api.item.IngredientStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.player.IPlayer;
import crafttweaker.util.ArrayUtil;
import java.util.Collections;
import java.util.List;

public class IngredientItem
implements IIngredient {
    private final IItemStack item;
    private final String mark;
    private final IItemCondition[] conditions;
    private final IItemTransformerNew[] transformerNews;
    private final List<IItemStack> items;
    private final IItemTransformer[] transformers;

    public IngredientItem(IItemStack item, String mark, IItemCondition[] conditions, IItemTransformerNew[] transformerNews, IItemTransformer[] transformers) {
        this.item = item;
        this.mark = mark;
        this.conditions = conditions;
        this.transformerNews = transformerNews;
        this.items = Collections.singletonList(item);
        this.transformers = transformers;
    }

    @Override
    public String getMark() {
        return this.mark;
    }

    @Override
    public int getAmount() {
        return this.item.getAmount();
    }

    @Override
    public List<IItemStack> getItems() {
        return this.items;
    }

    @Override
    public IItemStack[] getItemArray() {
        return this.items.toArray(new IItemStack[0]);
    }

    @Override
    public List<ILiquidStack> getLiquids() {
        return Collections.emptyList();
    }

    @Override
    public IIngredient amount(int amount) {
        return new IngredientStack(this, amount);
    }

    @Override
    public IIngredient transformNew(IItemTransformerNew transformer) {
        return new IngredientItem(this.item, this.mark, this.conditions, ArrayUtil.append(this.transformerNews, transformer), this.transformers);
    }

    @Override
    public IIngredient only(IItemCondition condition) {
        return new IngredientItem(this.item, this.mark, ArrayUtil.append(this.conditions, condition), this.transformerNews, this.transformers);
    }

    @Override
    public IIngredient marked(String mark) {
        return new IngredientItem(this.item, mark, this.conditions, this.transformerNews, this.transformers);
    }

    @Override
    public IIngredient or(IIngredient ingredient) {
        return new IngredientOr(this, ingredient);
    }

    @Override
    public boolean matches(IItemStack item) {
        if (!this.item.matches(item)) {
            return false;
        }
        for (IItemCondition condition : this.conditions) {
            if (condition.matches(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matchesExact(IItemStack item) {
        if (!this.item.matchesExact(item)) {
            return false;
        }
        for (IItemCondition condition : this.conditions) {
            if (condition.matches(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(ILiquidStack liquid) {
        return false;
    }

    @Override
    public boolean contains(IIngredient ingredient) {
        List<IItemStack> iitems = ingredient.getItems();
        for (IItemStack iitem : iitems) {
            if (this.matches(iitem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IItemStack applyTransform(IItemStack item, IPlayer byPlayer) {
        for (IItemTransformer transform : this.transformers) {
            item = transform.transform(item, byPlayer);
        }
        return item;
    }

    @Override
    public IItemStack applyNewTransform(IItemStack item) {
        for (IItemTransformerNew transform : this.transformerNews) {
            item = transform.transform(item);
        }
        return item;
    }

    @Override
    public boolean hasNewTransformers() {
        return this.transformerNews.length > 0;
    }

    @Override
    public boolean hasTransformers() {
        return this.transformers.length > 0;
    }

    @Override
    public IIngredient transform(IItemTransformer transformer) {
        return new IngredientItem(this.item, this.mark, this.conditions, this.transformerNews, (IItemTransformer[])stanhebben.zenscript.util.ArrayUtil.add((Object[])this.transformers, (Object)transformer));
    }

    @Override
    public Object getInternal() {
        return this.item.getInternal();
    }

    public String toString() {
        return "(Ingredient) " + this.item.toString();
    }

    @Override
    public String toCommandString() {
        return this.item.toCommandString();
    }
}

