package crafttweaker.api.recipes;

import crafttweaker.api.item.*;
import crafttweaker.api.player.IPlayer;

import java.util.*;

/**
 * @author Stan
 */
@Deprecated
public class ShapedRecipe implements ICraftingRecipe {
    
    private final int width;
    private final int height;
    private final byte[] posx;
    private final byte[] posy;
    private final boolean mirrored;
    private final IRecipeFunction function;
    private final IRecipeAction action;
    
    
    private final IItemStack output;
    private final IIngredient[] ingredients;
    private final String name;
    
    public ShapedRecipe(IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action, boolean mirrored) {
        this("", output, ingredients, function, action, mirrored);
    }
    
    public ShapedRecipe(String name, IItemStack output, IIngredient[][] ingredients, IRecipeFunction function, IRecipeAction action, boolean mirrored) {
        int numIngredients = 0;
        for(IIngredient[] ingredient : ingredients) {
            for(IIngredient anIngredient : ingredient) {
                if(anIngredient != null) {
                    numIngredients++;
                }
            }
        }
        //        for(IIngredient[] row : ingredients) {
        //			for(IIngredient ingredient : row) {
        //				if(ingredient != null) {
        //					numIngredients++;
        //				}
        //			}
        //		}
        this.posx = new byte[numIngredients];
        this.posy = new byte[numIngredients];
        this.output = output;
        this.ingredients = new IIngredient[numIngredients];
        this.function = function;
        this.action = action;
        this.name = name;
        
        int width1 = 0;
        int height1 = ingredients.length;
        
        int ix = 0;
        for(int j = 0; j < ingredients.length; j++) {
            IIngredient[] row = ingredients[j];
            width1 = Math.max(width1, row.length);
            
            for(int i = 0; i < row.length; i++) {
                if(row[i] != null) {
                    this.posx[ix] = (byte) i;
                    this.posy[ix] = (byte) j;
                    this.ingredients[ix] = row[i];
                    ix++;
                }
            }
        }
        
        this.width = width1;
        this.height = height1;
        this.mirrored = mirrored;
    }
    
    public int getWidth() {
        return width;
    }
    
    public int getHeight() {
        return height;
    }
    
    public boolean isMirrored() {
        return mirrored;
    }
    
    public IIngredient[] getIngredients() {
        return ingredients;
    }
    
    public byte[] getIngredientsX() {
        return posx;
    }
    
    public byte[] getIngredientsY() {
        return posy;
    }
    
    public IItemStack getOutput() {
        return output;
    }
    
    public String getName() {
        return name;
    }
    
    @Override
    public String getFullResourceName() {
        return null;
    }
    
    @Override
    public String getResourceDomain() {
        return null;
    }
    
    public boolean matches(ICraftingInventory inventory) {
        if(inventory.getStackCount() != ingredients.length) {
            return false;
        }
        for(int i = 0; i <= inventory.getWidth() - width; i++) {
            out:
            for(int j = 0; j <= inventory.getHeight() - height; j++) {
                for(int k = 0; k < ingredients.length; k++) {
                    IItemStack item = inventory.getStack(posy[k] + j, posx[k] + i);
                    if(item == null)
                        continue out;
                    
                    if(!ingredients[k].matches(item))
                        continue out;
                }
                
                return true;
            }
        }
        
        if(mirrored) {
            for(int i = 0; i <= inventory.getWidth() - width; i++) {
                out:
                for(int j = 0; j <= inventory.getHeight() - height; j++) {
                    for(int k = 0; k < ingredients.length; k++) {
                        IItemStack item = inventory.getStack(posy[k] + j, inventory.getWidth() - (posx[k] + i) - 1);
                        if(item == null)
                            continue out;
                        
                        if(!ingredients[k].matches(item))
                            continue out;
                    }
                    
                    return true;
                }
            }
        }
        
        return false;
    }
    
    public IItemStack getCraftingResult(ICraftingInventory inventory) {
        IItemStack[] stacks = new IItemStack[ingredients.length];
        
        for(int i = 0; i <= inventory.getWidth() - width; i++) {
            out:
            for(int j = 0; j <= inventory.getHeight() - height; j++) {
                for(int k = 0; k < ingredients.length; k++) {
                    IItemStack item = inventory.getStack(posy[k] + j, posx[k] + i);
                    if(item == null)
                        continue out;
                    
                    if(!ingredients[k].matches(item))
                        continue out;
                    stacks[k] = item;
                }
                
                return doRecipe(inventory, stacks, i, j, output, false);
            }
        }
        
        if(mirrored) {
            for(int i = 0; i <= inventory.getWidth() - width; i++) {
                out:
                for(int j = 0; j <= inventory.getHeight() - height; j++) {
                    for(int k = 0; k < ingredients.length; k++) {
                        IItemStack item = inventory.getStack(posy[k] + j, inventory.getWidth() - (posx[k] + i) - 1);
                        if(item == null)
                            continue out;
                        
                        if(!ingredients[k].matches(item))
                            continue out;
                        stacks[k] = item;
                    }
                    
                    return doRecipe(inventory, stacks, i, j, output, true);
                }
            }
        }
        
        return null;
    }
    
    public boolean hasTransformers() {
        for(IIngredient ingredient : ingredients) {
            if(ingredient.hasNewTransformers()) {
                return true;
            }
        }
        
        return false;
    }
    
    @Override
    public boolean hasRecipeAction() {
        return false;
    }
    
    @Override
    public boolean hasRecipeFunction() {
        return false;
    }
    
    public void applyTransformers(ICraftingInventory inventory, IPlayer byPlayer) {
        IItemStack[] stacks = new IItemStack[ingredients.length];
        
        for(int i = 0; i <= inventory.getWidth() - width; i++) {
            out:
            for(int j = 0; j <= inventory.getHeight() - height; j++) {
                for(int k = 0; k < ingredients.length; k++) {
                    IItemStack item = inventory.getStack(posy[k] + j, posx[k] + i);
                    if(item == null)
                        continue out;
                    
                    if(!ingredients[k].matches(item))
                        continue out;
                    stacks[k] = item;
                }
                
                doRecipeTransformers(inventory, stacks, i, j, false, byPlayer);
                return;
            }
        }
        
        if(mirrored) {
            for(int i = 0; i <= inventory.getWidth() - width; i++) {
                out:
                for(int j = 0; j <= inventory.getHeight() - height; j++) {
                    for(int k = 0; k < ingredients.length; k++) {
                        IItemStack item = inventory.getStack(posy[k] + j, inventory.getWidth() - (posx[k] + i) - 1);
                        if(item == null)
                            continue out;
                        
                        if(!ingredients[k].matches(item))
                            continue out;
                        stacks[k] = item;
                    }
                    
                    doRecipeTransformers(inventory, stacks, i, j, true, byPlayer);
                    return;
                }
            }
        }
    }
    
    @Override
    public IIngredient[] getIngredients1D() {
        return new IIngredient[0];
    }
    
    @Override
    public IIngredient[][] getIngredients2D() {
        return new IIngredient[0][];
    }
    
    @Override
    public boolean isHidden() {
        return false;
    }
    
    @Override
    public boolean isShaped() {
        return false;
    }
    
    @Override
    public String toCommandString() {
        StringBuilder result = new StringBuilder();
        result.append("recipes.addShaped(");
        if(output != null) {
            result.append(output);
        } else {
            result.append("null");
        }
        result.append(", [");
        
        IIngredient[][] ingredientsArray = new IIngredient[height][width];
        for(int i = 0; i < ingredients.length; i++) {
            ingredientsArray[posy[i]][posx[i]] = ingredients[i];
        }
        
        for(int i = 0; i < ingredientsArray.length; i++) {
            if(i > 0) {
                result.append(", ");
            }
            
            result.append("[");
            
            for(int j = 0; j < ingredientsArray[i].length; j++) {
                if(j > 0)
                    result.append(", ");
                
                result.append(ingredientsArray[i][j]);
            }
            
            result.append("]");
        }
        
        result.append("]);");
        
        return result.toString();
    }
    
    private IItemStack doRecipe(ICraftingInventory inventory, IItemStack[] stacks, int offx, int offy, IItemStack output, boolean mirrored) {
        // determine output and apply transformations
        
        if(function != null) {
            Map<String, IItemStack> tagged = new HashMap<>();
            for(int k = 0; k < ingredients.length; k++) {
                if(ingredients[k].getMark() != null) {
                    tagged.put(ingredients[k].getMark(), stacks[k]);
                }
            }
            
            output = function.process(output, tagged, new CraftingInfo(inventory, null));
            System.out.println("Ouput: " + output);
        }
        
        if(output == null) {
            return null;
        }
        
        /*
         * for (int i = 0; i < ingredients.length; i++) { IItemStack transformed
         * = ingredients[i].applyNewTransform(stacks[i]); if (transformed !=
         * stacks[i]) { if (mirrored) { inventory.setStack( inventory.getWidth()
         * - (offx + posx[i]) - 1, offy + posy[i], transformed); } else {
         * inventory.setStack( offx + posx[i], offy + posy[i], transformed); } }
         * }
         */
        
        return output;
    }
    
    private void doRecipeTransformers(ICraftingInventory inventory, IItemStack[] stacks, int offx, int offy, boolean mirrored, IPlayer byPlayer) {
        for(int i = 0; i < ingredients.length; i++) {
            IItemStack transformed = ingredients[i].applyNewTransform(stacks[i]);
            if(transformed != stacks[i]) {
                if(mirrored) {
                    inventory.setStack(offy + posy[i], inventory.getWidth() - (offx + posx[i]) - 1, transformed);
                } else {
                    inventory.setStack(offy + posy[i], offx + posx[i], transformed);
                }
            }
        }
    }
    
    public IRecipeAction getAction() {
        return action;
    }
}